/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities;

import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IClientConfig;
import com.gitlab.srcmc.rctmod.api.data.TrainerBattle;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import com.gitlab.srcmc.rctmod.world.entities.goals.LookAtPlayerAndWaitGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.MoveCloseToTargetGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.MoveToHomePosGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.PokemonBattleGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.RandomStrollAwayGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.RandomStrollThroughVillageGoal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1564;
import net.minecraft.class_1581;
import net.minecraft.class_1604;
import net.minecraft.class_1632;
import net.minecraft.class_1634;
import net.minecraft.class_1642;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5136;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8567;

public class TrainerMob
extends class_1314
implements class_1655 {
    private static final class_2940<String> DATA_TRAINER_ID = class_2945.method_12791(TrainerMob.class, (class_2941)class_2943.field_13326);
    private static final class_1299<TrainerMob> TYPE = class_1299.class_1300.method_5903(TrainerMob::new, (class_1311)class_1311.field_17715).method_20815().method_17687(0.6f, 1.95f).method_5905("trainer");
    private static final String TRAINER_TYPE_DEFAULT_REPLY = "missing_beaten_trainer";
    private static final Map<String, String> TRAINER_TYPE_REPLIES = Map.of("leader", "missing_badges", "e4", "missing_beaten_e4", "champ", "missing_beaten_champs", "rival", "missing_beaten_rival", "team_rocket", "missing_beaten_team_rocket", "team_plasma", "missing_beaten_team_plasma", "team_shadow", "missing_beaten_team_shadow");
    static final int TICKS_TO_DESPAWN = 600;
    static final int DESPAWN_TICK_SCALE = 20;
    static final int DESPAWN_DISTANCE = 128;
    static final int MAX_PLAYER_TRACKING_RANGE = 128;
    static final int TARGET_UPDATE_INTERVAL = 120;
    static final int AFK_CHECK_INTERVAL_TICKS = 2400;
    static final int AFK_CHECK_MAX_COUNT = 6;
    static final int AFK_PLAYER_MAX_COUNT = 3;
    static int MAX_TRAINER_ID_CHECK_RETRY_TICK = 600;
    static int TRAINER_ID_CHECK_RETRY_TICK = 20;
    private Map<UUID, int[]> winsAndDefeats = new HashMap<UUID, int[]>();
    private int cooldown;
    private class_1657 opponent;
    private UUID originPlayer;
    private boolean persistent;
    private int despawnTicks;
    private class_2338 homePos;
    private List<PlayerTransform> nearestTransforms = new ArrayList<PlayerTransform>();
    private int nearestAfkCheckCount;
    private int trainerIdCheckRetryTicks;
    private int trainerIdCheckFails;
    private String targetTrainerid;

    protected TrainerMob(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5665((class_2561)class_2561.method_43470((String)"Trainer"));
    }

    public static class_1299<TrainerMob> getEntityType() {
        return TYPE;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23716, 30.0);
    }

    public boolean canBattleAgainst(class_1297 e) {
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            RCTMod rct = RCTMod.getInstance();
            TrainerManager tm = rct.getTrainerManager();
            TrainerPlayerData tpd = tm.getData(player);
            TrainerMobData tmd = tm.getData(this);
            return this.getCooldown() == 0 && !this.isInBattle() && !rct.isInBattle(player) && tm.getActivePokemon(player) > 0 && tpd.getLevelCap() >= tmd.getRequiredLevelCap() && tm.getPlayerLevel(player) <= tpd.getLevelCap() && tmd.getMissingRequirements(tm.getData(player).getDefeatedTrainerIds()).findFirst().isEmpty() && this.couldBattleAgainst(e);
        }
        return false;
    }

    public boolean couldBattleAgainst(class_1297 e) {
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            return this.method_5947() || !this.wasDefeatedBy(player.method_5667()) && !this.wasVictoriousAgainst(player.method_5667());
        }
        return false;
    }

    public void startBattleWith(class_1657 player) {
        if (this.canBattleAgainst((class_1297)player)) {
            if (RCTMod.getInstance().makeBattle(this, player)) {
                this.setOpponent(player);
                RCTMod.getInstance().getTrainerManager().addBattle(player, this);
                ChatUtils.reply(this, player, "battle_start");
            }
        } else {
            this.replyTo(player);
        }
    }

    protected void replyTo(class_1657 player) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        TrainerMobData tmd = tm.getData(this);
        TrainerPlayerData tpd = tm.getData(player);
        Optional<String> msr = tmd.getMissingRequirements(tm.getData(player).getDefeatedTrainerIds()).findFirst();
        if (this.isInBattle()) {
            ChatUtils.reply(this, player, "is_busy");
        } else if (!this.method_5947() && this.wasDefeatedBy(player.method_5667())) {
            ChatUtils.reply(this, player, "done_looser");
        } else if (!this.method_5947() && this.wasVictoriousAgainst(player.method_5667())) {
            ChatUtils.reply(this, player, "done_winner");
        } else if (this.getCooldown() > 0) {
            ChatUtils.reply(this, player, "on_cooldown");
        } else if (RCTMod.getInstance().isInBattle(player)) {
            ChatUtils.reply(this, player, "player_busy");
        } else if (msr.isPresent()) {
            ChatUtils.reply(this, player, TRAINER_TYPE_REPLIES.getOrDefault(tm.getData(msr.get()).getType().id(), TRAINER_TYPE_DEFAULT_REPLY));
        } else if (tpd.getLevelCap() < tmd.getRequiredLevelCap()) {
            ChatUtils.reply(this, player, "low_level_cap");
        } else if (tm.getPlayerLevel(player) > tpd.getLevelCap()) {
            ChatUtils.reply(this, player, "over_level_cap");
        } else if (tm.getActivePokemon(player) == 0) {
            ChatUtils.reply(this, player, "missing_pokemon");
        } else {
            ChatUtils.reply(this, player, "done_generic");
        }
    }

    protected void setOpponent(class_1657 player) {
        this.opponent = player;
    }

    public class_1657 getOpponent() {
        return this.opponent;
    }

    public boolean isInBattle() {
        return this.opponent != null;
    }

    private void addWins(class_1657 player, int wins) {
        this.winsAndDefeats.compute(player.method_5667(), (k, v) -> {
            if (v == null) {
                return new int[]{wins, 0};
            }
            v[0] = v[0] + wins;
            return v;
        });
    }

    private void addDefeats(class_1657 player, int defeats) {
        this.winsAndDefeats.compute(player.method_5667(), (k, v) -> {
            if (v == null) {
                return new int[]{0, defeats};
            }
            v[1] = v[1] + defeats;
            return v;
        });
    }

    public boolean wasDefeatedBy(UUID opponentUUID) {
        int[] wd = this.winsAndDefeats.get(opponentUUID);
        return wd != null && wd[1] >= RCTMod.getInstance().getTrainerManager().getData(this).getMaxTrainerDefeats();
    }

    public boolean wasVictoriousAgainst(UUID opponentUUID) {
        int[] wd = this.winsAndDefeats.get(opponentUUID);
        return wd != null && wd[0] >= RCTMod.getInstance().getTrainerManager().getData(this).getMaxTrainerWins();
    }

    public boolean wasDefeated() {
        int maxDefeats = RCTMod.getInstance().getTrainerManager().getData(this).getMaxTrainerDefeats();
        if (maxDefeats > 0) {
            for (int[] wd : this.winsAndDefeats.values()) {
                if (wd[1] < maxDefeats) continue;
                return true;
            }
        }
        return false;
    }

    public boolean wasVictorious() {
        int maxWins = RCTMod.getInstance().getTrainerManager().getData(this).getMaxTrainerWins();
        if (maxWins > 0) {
            for (int[] wd : this.winsAndDefeats.values()) {
                if (wd[0] < maxWins) continue;
                return true;
            }
        }
        return false;
    }

    public boolean wasExhausted() {
        return !this.method_5947() && (this.wasDefeated() || this.wasVictorious());
    }

    private void udpateCustomName() {
        TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(this);
        this.method_5665((class_2561)class_2561.method_43470((String)tmd.getTrainerTeam().getName()));
    }

    public class_2561 method_5476() {
        String sym;
        TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(this);
        StringBuilder suffix = new StringBuilder();
        class_5250 cmp = this.method_5797().method_27661();
        class_1937 level = this.method_37908();
        boolean showSymbols = false;
        boolean showColors = true;
        boolean showItalic = false;
        if (level.field_9236) {
            IClientConfig cfg = RCTMod.getInstance().getClientConfig();
            showSymbols = cfg.showTrainerTypeSymbols();
            showColors = cfg.showTrainerTypeColors();
            boolean bl = showItalic = PlayerState.get(ModCommon.localPlayer()).getTrainerDefeatCount(this.getTrainerId()) == 0;
        }
        if (showSymbols && (sym = tmd.getType().symbol()).length() > 0) {
            suffix.append(' ').append(sym);
        }
        if (showColors) {
            cmp.method_10862(cmp.method_10866().method_36139(tmd.getType().color()));
        }
        if (showItalic) {
            cmp.method_10862(cmp.method_10866().method_10978(Boolean.valueOf(true)));
        }
        return cmp.method_27693(suffix.toString());
    }

    public void setTrainerId(String trainerId) {
        String currentId;
        class_1937 level = this.method_37908();
        if (!level.field_9236 && !Objects.equals(currentId = this.getTrainerId(), trainerId)) {
            RCTMod.getInstance().getTrainerSpawner().notifyChangeTrainerId(this, trainerId);
            this.field_6011.method_12778(DATA_TRAINER_ID, (Object)trainerId);
            this.targetTrainerid = trainerId;
            this.trainerIdCheckFails = 0;
            this.updateTrainerNPC(trainerId);
        }
    }

    private void updateTrainerNPC(String trainerId) {
        block4: {
            try {
                TrainerNPC trainer = (TrainerNPC)ModCommon.RCT.getTrainerRegistry().getById(trainerId, TrainerNPC.class);
                if (trainer != null) {
                    trainer.setEntity((class_1309)this);
                    this.udpateCustomName();
                    this.trainerIdCheckFails = 0;
                    break block4;
                }
                int fails = this.trainerIdCheckFails + 1;
                int ticks = fails * TRAINER_ID_CHECK_RETRY_TICK;
                if (ticks <= MAX_TRAINER_ID_CHECK_RETRY_TICK) {
                    this.trainerIdCheckRetryTicks = ticks;
                    this.trainerIdCheckFails = fails;
                    ModCommon.LOG.error(String.format("Invalid trainer id '%s' (%s): not found (retry in %d ticks)", trainerId, this.method_5845(), this.trainerIdCheckRetryTicks));
                    break block4;
                }
                throw new IllegalStateException(String.format("Failed to retrieve trainer '%s'. Was it successfully registered to the trainer registry?", trainerId));
            }
            catch (IllegalArgumentException e) {
                ModCommon.LOG.error(String.format("Invalid trainer id '%s' (%s)", trainerId, this.method_5845()), (Throwable)e);
            }
        }
    }

    public String getTrainerId() {
        return (String)this.field_6011.method_12789(DATA_TRAINER_ID);
    }

    public void setHomePos(class_2338 blockPos) {
        class_2338 currentHome;
        class_1937 level = this.method_37908();
        if (!level.field_9236 && !Objects.equals(currentHome = this.getHomePos(), blockPos)) {
            this.homePos = blockPos;
        }
    }

    public class_2338 getHomePos() {
        return this.homePos;
    }

    public void finishBattle(TrainerBattle battle, boolean defeated) {
        class_1937 level = this.method_37908();
        if (!level.field_9236 && this.isInBattle()) {
            TrainerMobData mobTr = RCTMod.getInstance().getTrainerManager().getData(this);
            class_1657 opponent = this.getOpponent();
            this.cooldown = mobTr.getBattleCooldownTicks();
            this.setOpponent(null);
            this.method_5980(null);
            if (defeated) {
                if (battle.getInitiatorSideMobs().contains((Object)this)) {
                    battle.getTrainerSidePlayers().forEach(player -> ChatUtils.reply(this, player, "battle_lost"));
                } else {
                    TrainerManager tm = RCTMod.getInstance().getTrainerManager();
                    List<class_1657> initiatorSidePlayer = battle.getInitiatorSidePlayers();
                    class_1657 minWinsPlayer = null;
                    for (class_1657 player2 : initiatorSidePlayer) {
                        ChatUtils.reply(this, player2, "battle_lost");
                        minWinsPlayer = minWinsPlayer == null || tm.getBattleMemory(this).getDefeatByCount(this.getTrainerId(), player2) < tm.getBattleMemory(this).getDefeatByCount(this.getTrainerId(), minWinsPlayer) ? player2 : minWinsPlayer;
                    }
                    if (minWinsPlayer != null) {
                        this.dropBattleLoot(mobTr.getLootTableResource(), minWinsPlayer);
                    }
                }
                if (opponent != null) {
                    this.addDefeats(opponent, 1);
                }
            } else {
                if (battle.getInitiatorSideMobs().contains((Object)this)) {
                    battle.getTrainerSidePlayers().forEach(player -> ChatUtils.reply(this, player, "battle_won"));
                } else {
                    battle.getInitiatorSidePlayers().forEach(player -> ChatUtils.reply(this, player, "battle_won"));
                }
                this.addWins(opponent, 1);
            }
            if (this.originPlayer != null && (this.wasDefeatedBy(this.originPlayer) || this.wasVictoriousAgainst(this.originPlayer))) {
                this.setOriginPlayer(null);
            }
        }
    }

    public void cancelBattle() {
        if (this.opponent != null) {
            RCTMod.getInstance().getTrainerManager().removeBattle(this.opponent.method_5667());
            RCTMod.getInstance().stopBattle(this);
            this.setOpponent(null);
        }
    }

    protected void dropBattleLoot(class_2960 lootTableResource, class_1657 player) {
        class_1937 level = this.method_37908();
        class_52 lootTable = level.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableResource));
        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)level.method_48963().method_48830()).method_51874(class_181.field_1233, (Object)player).method_51871(RCTMod.getInstance().getTrainerManager().getData(player).getBonusLuck((int)(player.method_7292() * 10.0f)));
        lootTable.method_51880(builder.method_51875(class_173.field_1173), this.method_51851(), arg_0 -> ((TrainerMob)this).method_5775(arg_0));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_TRAINER_ID, (Object)"");
    }

    public void method_5773() {
        super.method_5773();
        class_1937 level = this.method_37908();
        if (!level.field_9236) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.trainerIdCheckFails > 0 && --this.trainerIdCheckRetryTicks < 0) {
                this.updateTrainerNPC(this.targetTrainerid);
            }
            if (this.isInBattle()) {
                class_1657 opponent = this.getOpponent();
                if (opponent != null && !opponent.method_5805()) {
                    this.addWins(opponent, 1);
                    this.cancelBattle();
                }
            } else {
                this.updateTarget();
            }
            if (!this.method_31481()) {
                RCTMod.getInstance().getTrainerSpawner().register(this);
            }
            this.checkDespawnNearAfkPlayers();
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1937 level = this.method_37908();
        if (!level.field_9236) {
            this.startBattleWith(player);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (RCTMod.getInstance().getServerConfig().logSpawning()) {
            ModCommon.LOG.info(String.format("Removed trainer '%s' (%s): %s", this.getTrainerId(), this.method_5845(), reason.toString()));
        }
        RCTMod.getInstance().getTrainerSpawner().unregister(this);
        this.cancelBattle();
        super.method_5650(reason);
    }

    private void updateTarget() {
        if (this.field_6012 % 120 == 0) {
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            int reqLevelCap = tm.getData(this).getRequiredLevelCap();
            this.method_5980(this.method_37908().method_18464(class_4051.method_36626().method_36627().method_18420(p -> PlayerState.get((class_1657)p).getLevelCap() >= reqLevelCap && !this.wasDefeatedBy(p.method_5667()) && !this.wasVictoriousAgainst(p.method_5667())), (class_1309)this, this.method_5829().method_1014(128.0)).stream().min((p1, p2) -> Integer.compare(Math.abs(tm.getPlayerLevel((class_1657)p1) - reqLevelCap), Math.abs(tm.getPlayerLevel((class_1657)p2) - reqLevelCap))).orElse(null));
        }
    }

    public void setPersistent(boolean persistent) {
        this.setPersistent(persistent, false);
    }

    public void setPersistent(boolean persistent, boolean silent) {
        if (this.persistent != persistent) {
            if (!silent) {
                RCTMod.getInstance().getTrainerSpawner().notifyChangePersistence(this, persistent);
            }
            this.persistent = persistent;
        }
    }

    public boolean method_5947() {
        return this.persistent;
    }

    public boolean method_31746() {
        return this.method_5947();
    }

    public boolean method_31747() {
        return true;
    }

    public boolean method_5974(double d) {
        return false;
    }

    public boolean method_5786(class_2487 tag) {
        return this.method_5947() && super.method_5786(tag);
    }

    public boolean method_61113(class_1937 level1, class_1937 level2) {
        return false;
    }

    public boolean shouldDespawn() {
        if (++this.despawnTicks % 20 == 0) {
            if (!this.isInBattle() && this.method_37908().method_18460((class_1297)this, (double)Math.max(128, RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers())) == null) {
                return this.despawnTicks >= 600;
            }
            this.despawnTicks = 0;
        }
        return false;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_17749;
    }

    protected class_3414 method_6002() {
        return class_3417.field_17748;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setOriginPlayer(UUID originPlayer) {
        if (this.originPlayer == null && originPlayer != null || this.originPlayer != null && !this.originPlayer.equals(originPlayer)) {
            RCTMod.getInstance().getTrainerSpawner().notifyChangeOriginPlayer(this, originPlayer);
            this.originPlayer = originPlayer;
        }
    }

    public UUID getOriginPlayer() {
        return this.originPlayer;
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("Cooldown", this.getCooldown());
        compoundTag.method_10582("TrainerId", this.getTrainerId());
        compoundTag.method_10556("Persistent", this.method_5947());
        if (this.homePos != null) {
            compoundTag.method_10544("HomePos", this.homePos.method_10063());
        }
        if (this.originPlayer != null) {
            compoundTag.method_25927("OriginPlayer", this.originPlayer);
        }
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_10545("Cooldown")) {
            this.cooldown = compoundTag.method_10550("Cooldown");
        }
        if (compoundTag.method_10545("TrainerId")) {
            this.setTrainerId(compoundTag.method_10558("TrainerId"));
        }
        if (compoundTag.method_10545("HomePos")) {
            this.setHomePos(class_2338.method_10092((long)compoundTag.method_10537("HomePos")));
        }
        if (compoundTag.method_10545("OriginPlayer")) {
            this.setOriginPlayer(compoundTag.method_25926("OriginPlayer"));
        }
        if (compoundTag.method_10545("Persistent")) {
            this.setPersistent(compoundTag.method_10577("Persistent"));
        }
    }

    public void method_6007() {
        super.method_6007();
        class_1937 level = this.method_37908();
        if (!level.field_9236 && this.method_5805() && this.field_5974.method_43048(400) == 0 && this.field_6213 == 0) {
            this.method_6025(1.0f);
        }
    }

    protected void method_5959() {
        int maxTrackingDistance = 2 * RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers();
        this.method_5942().method_6354(true);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new PokemonBattleGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1642.class, 8.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1564.class, 12.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1632.class, 8.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1634.class, 8.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1604.class, 15.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1581.class, 12.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_5136.class, 10.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1374((class_1314)this, 0.5));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 0.35, item -> item.method_31574((class_1792)ModRegistries.Items.TRAINER_CARD.get()), false));
        this.field_6201.method_6277(4, (class_1352)new LookAtPlayerAndWaitGoal((class_1308)this, class_1309.class, 2.0f, 0.04f, 160, 320));
        this.field_6201.method_6277(4, (class_1352)new LookAtPlayerAndWaitGoal((class_1308)this, class_1309.class, 4.0f, 0.004f, 80, 160));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1309.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new MoveToHomePosGoal(this));
        this.field_6201.method_6277(6, (class_1352)new MoveCloseToTargetGoal(this, 0.35, maxTrackingDistance));
        this.field_6201.method_6277(7, (class_1352)new RandomStrollThroughVillageGoal((class_1314)this, (double)0.35f, p -> Float.valueOf(this.wasExhausted() ? p.floatValue() * 0.25f : p.floatValue() * 0.75f)));
        this.field_6201.method_6277(8, (class_1352)new RandomStrollAwayGoal(this, 0.35));
        this.field_6201.method_6277(12, (class_1352)new class_1394((class_1314)this, 0.35));
    }

    public boolean isRequiredBy(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(this);
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData(player);
            return !tpd.getDefeatedTrainerIds().contains(this.getTrainerId()) && tmd.getMissingRequirements(tpd.getDefeatedTrainerIds()).findFirst().isEmpty();
        }
        return false;
    }

    private void checkDespawnNearAfkPlayers() {
        if (!this.method_5947() && this.field_6012 % 2400 == 0) {
            if (this.nearestAfkCheckCount >= 6) {
                this.method_31472();
                return;
            }
            class_1937 level = this.method_37908();
            List<PlayerTransform> nextTransforms = level.method_18464(class_4051.method_36626(), (class_1309)this, this.method_53510().method_1014((double)RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers())).stream().limit(3L).sorted((p1, p2) -> Integer.compare(p1.method_5628(), p2.method_5628())).map(x$0 -> new PlayerTransform(this, (class_1657)x$0)).toList();
            if (this.nearestTransforms.size() > 0 && nextTransforms.size() == this.nearestTransforms.size() && nextTransforms.containsAll(this.nearestTransforms)) {
                ++this.nearestAfkCheckCount;
            } else {
                this.nearestTransforms = nextTransforms;
                this.nearestAfkCheckCount = 0;
            }
        }
    }

    private class PlayerTransform {
        public final float xRot;
        public final float yRot;
        public final double x;
        public final double y;
        public final double z;

        public PlayerTransform(TrainerMob trainerMob, class_1657 player) {
            if (player != null) {
                this.x = player.method_19538().field_1352;
                this.y = player.method_19538().field_1351;
                this.z = player.method_19538().field_1350;
                this.xRot = player.method_36455();
                this.yRot = player.method_36454();
            } else {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 0.0;
                this.xRot = 0.0f;
                this.yRot = 0.0f;
            }
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z, Float.valueOf(this.xRot), Float.valueOf(this.yRot));
        }

        public boolean equals(Object o) {
            if (o instanceof PlayerTransform) {
                PlayerTransform t = (PlayerTransform)o;
                return this.x == t.x && this.y == t.y && this.z == t.z && this.xRot == t.xRot && this.yRot == t.yRot;
            }
            return false;
        }
    }
}

